# AI Navigation

The navigation system allows you to create characters that can intelligently move around the game world. These characters use navigation meshes that are created automatically from your [Scene][1] geometry. Dynamic obstacles allow you to alter the navigation of the characters at runtime, while NavMesh links let you build specific actions like opening doors or jumping over gaps or down from a ledge. This section describes Unity's navigation and pathfinding systems in detail.

The following table describes the main topics of the AI Navigation package documentation.

| **Topic**                                      | **Description**                                             |
|:-----------------------------------------------|:------------------------------------------------------------|
| [**What's new**](whats-new.md) | See what's changed in the latest version of the AI Navigation package. |
| [**Upgrade**](UpgradeGuide.md) | Convert your projects to work with the new navigation system. |
| [**Navigation System**](NavigationSystem.md)      | Understand the key concepts necessary to use AI Navigation in Unity. |
| [**Navigation Overview**](NavigationOverview.md)  | Create NavMeshes, agents, links, and obstacles with this package. |
| [**Navigation Interface**](Reference.md)          | Learn about the interface of the Navigation components in this package. |
| [**Samples**](Samples.md)                         | Learn about the sample projects included with this package. |
| [**Glossary**](Glossary.md)                       | View AI Navigation terminology definitions. |

## Additional resources
- [Navigation tutorial](http://unity3d.com/learn/tutorials/topics/navigation)
- [Unity Knowledge Base](https://support.unity3d.com/hc/en-us) 

[1]: https://docs.unity3d.com/Manual/CreatingScenes.html "A Scene contains the environments and menus of your game. Think of each unique Scene file as a unique level. In each Scene, you place your environments, obstacles, and decorations, essentially designing and building your game in pieces."
